<?php
/**
 * This file is part of the Klarna Kp module
 *
 * (c) Klarna AB
 *
 * For the full copyright and license information, please view the NOTICE
 * and LICENSE files that were distributed with this source code.
 */

namespace Klarna\Kp\Plugin\Payment\Helper;

use Klarna\Kp\Model\Payment\Kp;
use Magento\Payment\Model\Method\Factory;

class AdminDataPlugin
{

    /**
     * Factory for payment method models
     *
     * @var Factory
     */
    protected $methodFactory;

    /**
     * AdminDataPlugin constructor.
     *
     * @param Factory $paymentMethodFactory
     */
    public function __construct(Factory $paymentMethodFactory)
    {
        $this->methodFactory = $paymentMethodFactory;
    }

    /**
     * Modify results of getPaymentMethods() call to add in Klarna methods returned by API
     *
     * @param \Magento\Payment\Helper\Data $subject
     * @param array                        $result
     * @return array
     */
    public function afterGetPaymentMethods(
        \Magento\Payment\Helper\Data $subject,
        $result
    ) {
        foreach ($result as $code => $data) {
            if (in_array($code, Kp::KLARNA_METHODS)) {
                $result[$code]['title'] = $this->methodFactory->create('\Klarna\Kp\Model\Payment\Kp')->setCode($code)
                                                              ->getCleanTitle();
            }
        }
        return $result;
    }
}
