<?php
/**
 * This file is part of the Klarna Kp module
 *
 * (c) Klarna AB
 *
 * For the full copyright and license information, please view the NOTICE
 * and LICENSE files that were distributed with this source code.
 */

namespace Klarna\Kp\Plugin\Checkout\Block\Checkout;

use Klarna\Kp\Api\QuoteRepositoryInterface;
use Klarna\Kp\Model\Session;
use Magento\Framework\Exception\NoSuchEntityException;

class LayoutProcessorPlugin
{
    /**
     * @var QuoteRepositoryInterface
     */
    private $quoteRepository;

    /**
     * @var Session
     */
    private $session;

    /**
     * LayoutProcessorPlugin constructor.
     *
     * @param Session                  $session
     * @param QuoteRepositoryInterface $quoteRepository
     */
    public function __construct(
        Session $session,
        QuoteRepositoryInterface $quoteRepository
    ) {
        $this->session = $session;
        $this->quoteRepository = $quoteRepository;
    }

    /**
     * Checkout LayoutProcessor before process plugin.
     *
     * @param \Magento\Checkout\Block\Checkout\LayoutProcessor $processor
     * @param array                                            $jsLayout
     * @return array
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function beforeProcess(\Magento\Checkout\Block\Checkout\LayoutProcessor $processor, $jsLayout)
    {
        $configuration = &$jsLayout['components']['checkout']['children']['steps']['children']['billing-step']
        ['children']['payment']['children']['renders']['children'];

        if (!isset($configuration)) {
            return [$jsLayout];
        }

        if (!isset($configuration['klarna'])) {
            return [$jsLayout];
        }
        try {
            $methods = $this->quoteRepository->getActiveByQuote($this->session->getQuote())->getPaymentMethods();

            foreach ($methods as $method) {
                $configuration['klarna']['methods'][$method] = $configuration['klarna']['methods']['klarna_kp'];
            }
        } catch (NoSuchEntityException $e) {
            // Do nothing, we just don't get to modify the jsLayout
        }
        return [$jsLayout];
    }
}