/**
 * Copyright 2016 Klarna Bank AB (publ)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   Klarna
 * @package    Klarna_Kco
 * @author     Joe Constant <joe.constant@klarna.com>
 */
/*jshint browser:true jquery:true*/
/*global alert*/
define([
    'ko',
    'mage/utils/wrapper',
    'Klarna_Kp/js/view/payments/kp',
    'Klarna_Kp/js/model/debug',
    'Klarna_Kp/js/model/config',
    'Magento_Checkout/js/model/full-screen-loader'
], function (ko, wrapper, klarna, debug, config, loader) {
    'use strict';

    return function (overriddenFunction) {
        return wrapper.wrap(overriddenFunction, function (originalAction) {
            if (config.hasErrors()) {
                return originalAction();
            }
            debug.group('override');
            config.iframeEnabled(false);
            debug.log('iframe disabled');
            loader.startLoader();
            return originalAction().then(function () {
                config.iframeEnabled(true);
                loader.stopLoader();
                debug.log('iframe enabled');
                debug.groupEnd();
            });
        });
    }
});
