<?php
/**
 * This file is part of the Klarna KP module
 *
 * (c) Klarna Bank AB (publ)
 *
 * For the full copyright and license information, please view the NOTICE
 * and LICENSE files that were distributed with this source code.
 */
namespace Klarna\Kp\Observer;

use Klarna\Kp\Api\QuoteInterface;
use Klarna\Kp\Api\QuoteRepositoryInterface;
use Magento\Framework\DataObject;
use Magento\Framework\Event\Observer;
use Magento\Framework\Exception\LocalizedException;
use Magento\Payment\Model\InfoInterface;
use Magento\Payment\Observer\AbstractDataAssignObserver;
use Magento\Quote\Api\Data\PaymentInterface;

class AssignData extends AbstractDataAssignObserver
{
    /**
     * @var QuoteRepositoryInterface
     */
    protected $klarnaQuoteRepository;

    /**
     * AssignData constructor.
     *
     * @param QuoteRepositoryInterface $klarnaQuoteRepository
     */
    public function __construct(QuoteRepositoryInterface $klarnaQuoteRepository)
    {
        $this->klarnaQuoteRepository = $klarnaQuoteRepository;
    }

    /**
     * Observer
     *
     * @param Observer $observer
     * @return void
     * @throws LocalizedException
     */
    public function execute(Observer $observer)
    {
        $data = $this->readDataArgument($observer);

        $additionalData = $data->getData(PaymentInterface::KEY_ADDITIONAL_DATA);
        if (!is_array($additionalData)) {
            return;
        }

        $additionalData = new DataObject($additionalData);
        $paymentMethod = $this->readMethodArgument($observer);

        $payment = $observer->getPaymentModel();
        if (!$payment instanceof InfoInterface) {
            $payment = $paymentMethod->getInfoInstance();
        }

        if (!$payment instanceof InfoInterface) {
            throw new LocalizedException(__('Payment model does not provided.'));
        }

        $quote = $payment->getQuote();
        /** @var QuoteInterface $klarnaQuote */
        $klarnaQuote = $this->klarnaQuoteRepository->getActiveByQuote($quote);
        $klarnaQuote->setAuthorizationToken($additionalData->getData('authorization_token'));
        $this->klarnaQuoteRepository->save($klarnaQuote);
    }
}
