<?php
/**
 * This file is part of the Klarna KP module
 *
 * (c) Klarna Bank AB (publ)
 *
 * For the full copyright and license information, please view the NOTICE
 * and LICENSE files that were distributed with this source code.
 */
namespace Klarna\Kp\Model\System\Config\Source;

use Magento\Framework\Config\DataInterface;
use Magento\Framework\Option\ArrayInterface;

/**
 * Class Version
 *
 * @package Klarna\Kp\Model\Config\Source
 */
class Version implements ArrayInterface
{

    /**
     * @var DataInterface
     */
    protected $config;

    public function __construct(DataInterface $config)
    {
        $this->config = $config;
    }

    /**
     * Options getter
     *
     * @return array
     */
    public function toOptionArray()
    {
        $options = [];
        $values = $this->config->get('payments_api_versions');

        if ($values) {
            foreach ($values as $name => $value) {
                $options[] = array(
                    'label' => $value['label'],
                    'value' => $name
                );
            }
        }

        return $options;
    }
}
