<?php
/**
 * This file is part of the Klarna KP module
 *
 * (c) Klarna Bank AB (publ)
 *
 * For the full copyright and license information, please view the NOTICE
 * and LICENSE files that were distributed with this source code.
 */
namespace Klarna\Kp\Observer;

use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Sales\Model\Order;
use Magento\Sales\Model\Order\Email\Sender\OrderSender;
use Psr\Log\LoggerInterface;

class CheckoutSubmitAfterAllSendOrderEmail implements ObserverInterface
{
    /**
     * @var OrderSender
     */
    protected $orderSender;

    /**
     * @var LoggerInterface
     */
    protected $logger;

    /**
     * CheckoutSubmitAfterAllSendOrderEmail constructor.
     *
     * @param LoggerInterface $logger
     * @param OrderSender     $orderSender
     */
    public function __construct(LoggerInterface $logger, OrderSender $orderSender)
    {
        $this->orderSender = $orderSender;
        $this->logger = $logger;
    }

    /**
     * @param Observer $observer
     * @return void
     */
    public function execute(Observer $observer)
    {
        /** @var Order $order */
        $order = $observer->getOrder();

        switch ($order->getState()) {
            case Order::STATE_PENDING_PAYMENT:
            case Order::STATE_PROCESSING:
            case Order::STATE_COMPLETE:
            case Order::STATE_PAYMENT_REVIEW:
                try {
                    $this->orderSender->send($order);
                } catch (\Exception $e) {
                    $this->logger->critical($e);
                }
                break;
        }
    }
}
