<?php
/**
 * This file is part of the Klarna KP module
 *
 * (c) Klarna Bank AB (publ)
 *
 * For the full copyright and license information, please view the NOTICE
 * and LICENSE files that were distributed with this source code.
 */
namespace Klarna\Kp\Gateway\Validator;

use Klarna\Core\Helper\ConfigHelper;
use Klarna\Kp\Api\Data\ResponseInterface;
use Klarna\Kp\Model\Payment\Kp;
use Klarna\Kp\Model\Session;
use Magento\Framework\Exception\NotFoundException;
use Magento\Payment\Gateway\Validator\AbstractValidator;
use Magento\Payment\Gateway\Validator\ResultInterfaceFactory;

/**
 * Class CountryValidator
 *
 * @package Magento\Payment\Gateway\Validator
 * @api
 */
class SessionValidator extends AbstractValidator
{
    /**
     * Session
     *
     * @var Session
     */
    private $session;
    /**
     * @var ConfigHelper
     */
    private $helper;

    /**
     * Constructor
     *
     * @param ResultInterfaceFactory $resultFactory
     * @param Session                $session
     * @param ConfigHelper           $helper
     */
    public function __construct(
        ResultInterfaceFactory $resultFactory,
        Session $session,
        ConfigHelper $helper
    ) {
        $this->session = $session;
        parent::__construct($resultFactory);
        $this->helper = $helper;
    }

    /**
     * Validate
     *
     * @param array $validationSubject
     * @return bool
     * @throws NotFoundException
     * @throws \Exception
     */
    public function validate(array $validationSubject)
    {
        $store = $this->session->getQuote()->getStore();
        if ($this->helper->getPaymentConfigFlag('active', $store, Kp::METHOD_CODE)) {
            return $this->createResult(false, ['Klarna Payments is not enabled']);
        }
        /** @var ResponseInterface $klarnaPayments */
        $klarnaPayments = $this->session->init();
        $isValid = $klarnaPayments->getIsSuccessfull();
        $fails = [$klarnaPayments->getMessage()];

        return $this->createResult($isValid, $fails);
    }
}
