/**
 * This file is part of the Klarna KP module
 *
 * (c) Klarna Bank AB (publ)
 *
 * For the full copyright and license information, please view the NOTICE
 * and LICENSE files that were distributed with this source code.
 */
define(
    [
        'jquery',
        'Magento_Checkout/js/model/quote',
        'Magento_Customer/js/model/customer',
        'Klarna_Kp/js/model/config',
        'Klarna_Kp/js/model/debug'
    ],
    function ($, quote, customer, config, debug) {
        'use strict';
        return {
            buildAddress: function (address, email) {
                var addr = {
                    'given_name': '',
                    'family_name': '',
                    'street_address': '',
                    'city': '',
                    'postal_code': '',
                    'country': '',
                    'phone': '',
                    'email': email
                };
                if (!address) { // Somehow we got a null passed in
                    return addr;
                }
                if (address.prefix) {
                    addr['title'] = address.prefix;
                }
                if (address.firstname) {
                    addr['given_name'] = address.firstname;
                }
                if (address.lastname) {
                    addr['family_name'] = address.lastname;
                }
                if (address.street) {
                    if (address.street.length > 0) {
                        addr['street_address'] = address.street[0];
                    }
                    if (address.street.length > 1) {
                        addr['street_address2'] = address.street[1];
                    }
                }
                if (address.city) {
                    addr['city'] = address.city;
                }
                if (address.regionCode) {
                    addr['region'] = address.regionCode;
                }
                if (address.postcode) {
                    addr['postal_code'] = address.postcode;
                }
                if (address.countryId) {
                    addr['country'] = address.countryId;
                }
                if (address.telephone) {
                    addr['phone'] = address.telephone;
                }
                debug.log(addr);
                return addr;
            },
            getUpdateData: function () {
                var email = '';
                if (customer.isLoggedIn()) {
                    email = customer.customerData.email;
                } else {
                    email = quote.guestEmail;
                }
                var data = {
                    'billing_address': this.buildAddress(quote.billingAddress(), email),
                    'shipping_address': this.buildAddress(quote.shippingAddress(), email)
                };
                debug.log(data);
                return data;
            },
            hide: function () {
                if ('klarna_kp' == quote.paymentMethod()) {
                    quote.paymentMethod(null);
                }
            },
            load: function (callback) {
                if (!Klarna.Credit.initialized) {
                    this.init();
                }
                this.show(callback);
            },
            show: function (callback) {
                var self = this;
                if (Klarna.Credit.initialized && $('#klarna-payments-container').length) {
                    Klarna.Credit.load({
                            container: "#klarna-payments-container"
                        },
                        function (res) {
                            debug.log(res);
                            if (true !== res.show_form) {
                                self.hide();
                            }
                            var errors = false;
                            if (res.errors) {
                                errors = true;
                            }
                            config.hasErrors(errors);
                            if (callback) {
                                callback(res);
                            }
                        });
                } else {
                    setTimeout(function () {
                        self.show(callback);
                    }, 100);
                }
            },
            init: function () {
                Klarna.Credit.init({
                    client_token: config.client_token
                });
            },
            authorize: function (data, callback) {
                Klarna.Credit.authorize(data, function (res) {
                    debug.log(res);
                    if (true === res.approved) {
                        config.authorization_token(res.authorization_token);
                    }
                    var errors = false;
                    if (res.errors) {
                        errors = true;
                    }
                    config.hasErrors(errors);
                    callback(res);
                });
            }
        }
    }
);
