<?php
/**
 * This file is part of the Klarna KP module
 *
 * (c) Klarna Bank AB (publ)
 *
 * For the full copyright and license information, please view the NOTICE
 * and LICENSE files that were distributed with this source code.
 */
namespace Klarna\Kp\Gateway\Validator;

use Klarna\Kp\Api\Data\ResponseInterface;
use Klarna\Kp\Model\Session;
use Magento\Framework\Exception\NotFoundException;
use Magento\Payment\Gateway\Validator\AbstractValidator;
use Magento\Payment\Gateway\Validator\ResultInterfaceFactory;

/**
 * Class CountryValidator
 *
 * @package Magento\Payment\Gateway\Validator
 * @api
 */
class SessionValidator extends AbstractValidator
{
    /**
     * Session
     *
     * @var Session
     */
    private $session;

    /**
     * Constructor
     *
     * @param ResultInterfaceFactory $resultFactory
     * @param Session                $session
     */
    public function __construct(
        ResultInterfaceFactory $resultFactory,
        Session $session
    ) {
        $this->session = $session;
        parent::__construct($resultFactory);
    }

    /**
     * Validate
     *
     * @param array $validationSubject
     * @return bool
     * @throws NotFoundException
     * @throws \Exception
     */
    public function validate(array $validationSubject)
    {
        /** @var ResponseInterface $klarnaPayments */
        $klarnaPayments = $this->session->init();
        $isValid = $klarnaPayments->getIsSuccessfull();
        $fails = [$klarnaPayments->getMessage()];

        return $this->createResult($isValid, $fails);
    }
}
