<?php
/**
 * This file is part of the Klarna KP module
 *
 * (c) Klarna Bank AB (publ)
 *
 * For the full copyright and license information, please view the NOTICE
 * and LICENSE files that were distributed with this source code.
 */
namespace Klarna\Kp\Observer;

use Klarna\Core\Helper\ConfigHelper;
use Klarna\Kp\Model\Payment\Kp;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Quote\Model\QuoteRepository;
use Magento\Store\Model\ScopeInterface;

class PreselectKlarnaOnQuote implements ObserverInterface
{

    /**
     *
     * @var ConfigHelper
     */
    protected $helper;

    /**
     * PreselectKlarnaOnQuote constructor.
     *
     * @param ConfigHelper    $helper
     * @param QuoteRepository $quoteRepository
     */
    public function __construct(ConfigHelper $helper)
    {
        $this->helper = $helper;
    }

    /**
     * @param Observer $observer
     * @return void
     */
    public function execute(Observer $observer)
    {
        /** @var \Magento\Quote\Model\Quote $quote */
        $quote = $observer->getQuote();
        if ($quote->getPayment()->getMethod()) {
            return; // Don't change existing payment method on quote
        }
        $store = $quote->getStore();
        if ($this->helper->getPaymentConfigFlag('force_default', $store, Kp::METHOD_CODE)) {
            $quote->getPayment()->setMethod(Kp::METHOD_CODE);
        }
    }
}
