<?php
/**
 * This file is part of the Klarna Core module
 *
 * (c) Klarna Bank AB (publ)
 *
 * For the full copyright and license information, please view the NOTICE
 * and LICENSE files that were distributed with this source code.
 */

namespace Klarna\Core\Logger;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Store\Model\ScopeInterface;
use Magento\Store\Model\StoreManagerInterface;
use Monolog\Logger as MonoLogger;

/**
 * Class Logger
 *
 * @package Klarna\Core\Logger
 */
class Logger extends MonoLogger
{
    /**
     * @var ScopeConfigInterface
     */
    private $config;
    /**
     * @var StoreManagerInterface
     */
    private $storeManager;
    /**
     * @var Cleanser
     */
    private $cleanser;

    /**
     * Logger constructor.
     *
     * @param string                              $name
     * @param ScopeConfigInterface                $config
     * @param Cleanser                            $cleanser
     * @param StoreManagerInterface               $storeManager
     * @param \Monolog\Handler\HandlerInterface[] $handlers
     * @param \callable[]                         $processors
     * @codeCoverageIgnore
     */
    public function __construct(
        $name,
        ScopeConfigInterface $config,
        Cleanser $cleanser,
        StoreManagerInterface $storeManager,
        array $handlers = [],
        array $processors = []
    ) {
        parent::__construct($name, $handlers, $processors);
        $this->config = $config;
        $this->cleanser = $cleanser;
        $this->storeManager = $storeManager;
    }

    /**
     * @inheritdoc
     */
    public function addRecord($level, $message, array $context = [])
    {
        if (!$this->config->isSetFlag(
            'klarna/api/debug',
            ScopeInterface::SCOPE_STORE,
            $this->storeManager->getStore()
        )
        ) {
            return false;
        }
        if (null !== $message && !is_string($message)) {
            $message = $this->cleanser->checkForSensitiveData($message);
            $message = print_r($message, true);
        }
        if (!empty($context)) {
            $context = $this->cleanser->checkForSensitiveData($context);
        }
        return parent::addRecord($level, $message, $context);
    }
}
