<?php
/**
 * This file is part of the Klarna Core module
 *
 * (c) Klarna AB
 *
 * For the full copyright and license information, please view the NOTICE
 * and LICENSE files that were distributed with this source code.
 */

namespace Klarna\Core\Logger;

use Magento\Framework\DataObject;

/**
 * Class Cleanser
 *
 * @package Klarna\Core\Logger
 */
class Cleanser
{
    /**
     * List of keys that should never be logged
     *
     * @var string[]
     */
    public $privateKeys = [
        'password',
        'shared_secret',
        'secret',
        'date_of_birth',
        '_secret',
        'Authorization',
        'gender'
    ];

    /**
     * Value to be substituted instead of sensitve data
     *
     * @var string
     */
    public $replaceValue = '** REMOVED **';

    /**
     * Search object for sensitive data and replace it if found
     *
     * @param mixed $input
     * @return mixed
     */
    public function checkForSensitiveData($input = null)
    {
        if (is_string($input)) {
            return $input;
        }
        if (null === $input) {
            return $input;
        }
        if (is_array($input)) {
            return $this->checkArrayForSensitiveData($input);
        }
        if ($input instanceof DataObject) { //is_object($input) && method_exists($input, 'getData')
            $data = $this->checkArrayForSensitiveData($input->getData());
            $input->setData($data);
            return $input;
        }
        if (is_object($input)) {
            /** @noinspection ForgottenDebugOutputInspection */
            $input = var_export((array)$input);
            return $this->checkForSensitiveData($input);
        }
        if ($json = json_decode($input, true)) {
            $json = $this->checkArrayForSensitiveData($json);
            return json_encode($json);
        }
        return $input;
    }

    /**
     * Recursively search array for sensitive data and replace it if found
     *
     * @param array $input
     * @return array
     */
    public function checkArrayForSensitiveData($input)
    {
        foreach ($input as $key => $value) {
            if (is_int($key)) {
                continue;
            }
            if (in_array($key, $this->privateKeys)) {
                $input[$key] = $this->replaceValue;
                continue;
            }
            if (is_array($value)) {
                $input[$key] = $this->checkArrayForSensitiveData($value);
            }
        }
        return $input;
    }
}
