<?php
/**
 * This file is part of the Klarna Core module
 *
 * (c) Klarna Bank AB (publ)
 *
 * For the full copyright and license information, please view the NOTICE
 * and LICENSE files that were distributed with this source code.
 */
namespace Klarna\Core\Helper;

use Magento\Composer\InfoCommand;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Magento\Framework\App\ProductMetadataInterface;
use Magento\Framework\App\State;
use Magento\Framework\Composer\ComposerInformation;
use Magento\Framework\Composer\MagentoComposerApplicationFactory;
use Magento\Framework\Config\DataInterface;
use Magento\Framework\DataObject;
use Magento\Framework\Locale\Resolver;
use Magento\Quote\Api\Data\CartInterface;
use Magento\Store\Model\Config\Processor\Placeholder;
use Magento\Store\Model\Store;

class VersionInfo
{

    /**
     * @var string
     */
    protected $mageMode;

    /**
     * @var string
     */
    protected $mageVersion;

    /**
     * @var ComposerInformation
     */
    protected $composerInformation;

    /**
     * @var InfoCommand
     */
    protected $infoCommand;

    /**
     * @var string
     */
    protected $mageEdition;

    /**
     * VersionInfo constructor.
     *
     * @param ProductMetadataInterface          $productMetadata
     * @param State                             $appState
     * @param ComposerInformation               $composerInformation
     * @param MagentoComposerApplicationFactory $magentoComposerApplicationFactory
     */
    public function __construct(
        ProductMetadataInterface $productMetadata,
        State $appState,
        ComposerInformation $composerInformation,
        MagentoComposerApplicationFactory $magentoComposerApplicationFactory
    ) {
        $this->composerInformation = $composerInformation;
        $this->infoCommand = $magentoComposerApplicationFactory->createInfoCommand();
        $this->mageMode = $appState->getMode();
        $this->mageEdition = $productMetadata->getEdition();
        $this->mageVersion = $productMetadata->getVersion();
    }

    /**
     * Get composer version for given package
     *
     * @param string $packageName
     * @return array|bool
     */
    public function getVersion($packageName)
    {
        $packageInfo = $this->getPackage($packageName);
        return $packageInfo[InfoCommand::CURRENT_VERSION];
    }

    /**
     * Get composer package info for given package name
     *
     * @param string $packageName
     * @return array|bool
     */
    public function getPackage($packageName)
    {
        return $this->infoCommand->run($packageName);
    }

    /**
     * Gets the current MAGE_MODE setting
     *
     * @return string
     */
    public function getMageMode()
    {
        return $this->mageMode;
    }

    /**
     * Gets the current Magento version
     *
     * @return string
     */
    public function getMageVersion()
    {
        return $this->mageVersion;
    }

    /**
     * Gets the current Magento Edition
     *
     * @return string
     */
    public function getMageEdition()
    {
        return $this->mageEdition;
    }
}
