<?php

namespace Dotdigitalgroup\Email\Test\Unit\Observer;


use Magento\Sales\Model\Order;
use Magento\Store\Model\StoreManagerInterface;
use Magento\TestFramework\ObjectManager;

class SaveRegisterOrderStatusBeforeTest extends \PHPUnit_Framework_TestCase
{

    public $_event;
    public $automationStatus;
    public $saveRegister;
    /**
     * @var \Magento\Framework\Event\Observer|\PHPUnit_Framework_MockObject_MockObject
     */
    private $eventObserverMock;


    /**
     * @var
     */
    private $observer;

    public function setUp()
    {
        $this->_event = new \Magento\Framework\DataObject();
        $this->observer = new \Magento\Framework\Event\Observer();
        $this->observer->setEvent($this->_event);

        $objectManager = new \Magento\Framework\TestFramework\Unit\Helper\ObjectManager($this);
        $this->saveRegister = $objectManager->getObject(
            'Dotdigitalgroup\Email\Observer\Sales\SaveRegisterOrderStatusBefore',
            []
        );
    }

    public function testRegistrySavedBeforeIsSet()
    {
        $event = 'sales_order_status_before';
        $registry = $this->getMock('\Magento\Framework\Registry', [], [], '', false);
        $registry->expects($this->once())
            ->method('registry')
            ->willReturn($event);

        $order = $this->getMock('\Magento\Framework\DataObject', [
            'getId', 'getStatus', 'getName', 'setData'], [], '', false);

//        $order->expects($this->once())
//            ->method('getStatus')
//            ->willReturn('Pending');

        $order->expects($this->once())
            ->method('getId')
            ->willReturn(false);

        $this->_event->setOrder($order);
        $this->saveRegister->execute($this->observer);
    }

    public function testRegistryNotSaved()
    {

    }

}
