<?php

namespace Dotdigitalgroup\Email\Test\Unit\Observer;


use Magento\Sales\Model\Order;
use Magento\Store\Model\StoreManagerInterface;
use Magento\TestFramework\ObjectManager;

class SaveAutomationStatusObserverTest extends \PHPUnit_Framework_TestCase
{

    public $_event;
    public $automationStatus;
    /**
     * @var \Magento\Framework\Event\Observer|\PHPUnit_Framework_MockObject_MockObject
     */
    private $eventObserverMock;


    /**
     * @var
     */
    private $observer;

    public function setUp()
    {
        $this->_event = new \Magento\Framework\DataObject();

        $this->observer = new \Magento\Framework\Event\Observer();
        $this->observer->setEvent($this->_event);

        $objectManager = new \Magento\Framework\TestFramework\Unit\Helper\ObjectManager($this);

        $this->automationStatus = $objectManager->getObject(
            'Dotdigitalgroup\Email\Observer\Sales\SaveStatusSmsAutomation',
            []
        );
    }

    public function testAutomationStatusInvoked()
    {
        $mockClient = $this->getMockBuilder(Order::class)
            ->disableOriginalConstructor()
            ->getMock();
        $mockClient->method('getStatus')->willReturn('Pending');

        $store = $this->getMock('\Magento\Framework\DataObject', ['setStore', 'getStore'], [], '', false);
        $order = $this->getMock('\Magento\Framework\DataObject', [
            'getStatus', 'getStoreId', 'getName', 'setData'], [], '', false);
        $storeManager = $this->getMockForAbstractClass('\Magento\Store\Model\StoreManagerInterface');

        $store->expects($this->once())
            ->method('getName')
            ->willReturn('Main');
        $store->expects($this->once())
            ->method('getWebsiteId')
            ->willReturn('1');

        $storeManager->expects($this->once())
            ->method('getStore')
            ->willReturn($store);


        $order->expects($this->once())
            ->method('getUpdatedAt')
            ->willReturn(time());
        $order->expects($this->once())
            ->method('getEntityId')
            ->willReturn('123');
        $order->expects($this->once())
            ->method('getQuoteId')
            ->willReturn('12');
        $order->expects($this->once())
            ->method('getCustomerEmail')
            ->willReturn('testing@gmail.com');
        $order->expects($this->once())
            ->method('getStatus')
            ->willReturn('Pending');
        $order->expects($this->once())
            ->method('getStoreId')
            ->willReturn('1');

        $this->_event->setOrder($order);
        $this->automationStatus->execute($this->observer);
    }

}
