<?php

namespace Dotdigitalgroup\Email\Model\SalesRule;

use Magento\Framework\Stdlib\DateTime;

class Coupon extends \Magento\SalesRule\Model\ResourceModel\Coupon
{

    /**
     * @var DateTime
     */
    public $dateTime;

    /**
     * Coupon constructor.
     *
     * @param DateTime                                          $dateTime
     * @param \Magento\Framework\Model\ResourceModel\Db\Context $context
     */
    public function __construct(
        DateTime $dateTime,
        \Magento\Framework\Model\ResourceModel\Db\Context $context
    ) {
        $this->dateTime = $dateTime;
        parent::__construct($context);
    }

    /**
     * Update auto generated Specific Coupon if it's rule changed
     *
     * @param \Magento\SalesRule\Model\Rule $rule
     * @return $this
     */
    public function updateSpecificCoupons(\Magento\SalesRule\Model\Rule $rule)
    {
        if (!$rule || !$rule->getId() || !$rule->hasDataChanges()) {
            return $this;
        }

        $updateArray = [];
        if ($rule->dataHasChangedFor('uses_per_coupon')) {
            $updateArray['usage_limit'] = $rule->getUsesPerCoupon();
        }

        if ($rule->dataHasChangedFor('uses_per_customer')) {
            $updateArray['usage_per_customer'] = $rule->getUsesPerCustomer();
        }

        $ruleNewDate = $this->dateTime->formatDate($rule->getToDate());
        $ruleOldDate = $this->dateTime->formatDate($rule->getOrigData('to_date'));

        if ($ruleNewDate != $ruleOldDate) {
            $updateArray['expiration_date'] = $rule->getToDate();
        }

        if (!empty($updateArray)) {
            $this->getConnection()->update(
                $this->getTable('salesrule_coupon'),
                $updateArray,
                ['rule_id = ?' => $rule->getId(), 'generated_by_dotmailer is null']
            );
        }

        //update coupons generated by dotmailer. not to change expiration date
        $dotmailerUpdateArray = $updateArray;
        unset($dotmailerUpdateArray['expiration_date']);
        if (!empty($dotmailerUpdateArray)) {
            $this->getConnection()->update(
                $this->getTable('salesrule_coupon'),
                $dotmailerUpdateArray,
                ['rule_id = ?' => $rule->getId(), 'generated_by_dotmailer = 1']
            );
        }

        return $this;
    }
}
