<?php

namespace Dotdigitalgroup\Email\Model\SalesRule;

class Coupon extends \Magento\SalesRule\Model\ResourceModel\Coupon
{
    /**
     * Update auto generated Specific Coupon if it's rule changed
     *
     * @param \Magento\SalesRule\Model\Rule $rule
     * @return $this
     */
    public function updateSpecificCoupons(\Magento\SalesRule\Model\Rule $rule)
    {
        if (!$rule || !$rule->getId() || !$rule->hasDataChanges()) {
            return $this;
        }

        $updateArray = [];
        if ($rule->dataHasChangedFor('uses_per_coupon')) {
            $updateArray['usage_limit'] = $rule->getUsesPerCoupon();
        }

        if ($rule->dataHasChangedFor('uses_per_customer')) {
            $updateArray['usage_per_customer'] = $rule->getUsesPerCustomer();
        }

        $ruleNewDate = new \DateTime($rule->getToDate());
        $ruleOldDate = new \DateTime($rule->getOrigData('to_date'));

        if ($ruleNewDate != $ruleOldDate) {
            $updateArray['expiration_date'] = $rule->getToDate();
        }

        if (!empty($updateArray)) {
            $this->getConnection()->update(
                $this->getTable('salesrule_coupon'),
                $updateArray,
                ['rule_id = ?' => $rule->getId(), 'generated_by_dotmailer is null']
            );
        }

        //update coupons generated by dotmailer. not to change expiration date
        $dotmailerUpdateArray = $updateArray;
        unset($dotmailerUpdateArray['expiration_date']);
        if (!empty($dotmailerUpdateArray)) {
            $this->getConnection()->update(
                $this->getTable('salesrule_coupon'),
                $dotmailerUpdateArray,
                ['rule_id = ?' => $rule->getId(), 'generated_by_dotmailer is 1']
            );
        }

        return $this;
    }
}
