<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace CommunityEngineering\JapaneseAddress\Block\Checkout;

use Magento\Checkout\Block\Checkout\LayoutProcessorInterface;

/**
 * Billing address component template can not be configured through layout XML as generated by PHP.
 *
 * This processor found all billing address components and set Japanese address template for them.
 */
class BillingAddressComponent implements LayoutProcessorInterface
{
    /**
     * @inheritDoc
     */
    public function process($jsLayout)
    {
        if (!isset($jsLayout['components']['checkout']['children']['steps']['children']['billing-step'])) {
            return $jsLayout;
        }

        $jsLayout['components']['checkout']['children']['steps']['children']['billing-step'] = $this->walkChildren(
            $jsLayout['components']['checkout']['children']['steps']['children']['billing-step']
        );

        return $jsLayout;
    }

    /**
     * Walk though components to find and modify billing address component to substitute template.
     *
     * @param array $component
     * @return array
     */
    private function walkChildren(array $component): array
    {
        if (!isset($component['children']) || !is_array($component['children'])) {
            return $component;
        }

        foreach ($component['children'] as $name => $child) {
            if ($component['component'] === 'Magento_Checkout/js/view/billing-address') {
                $component['config'] = array_merge(
                    isset($component['config']) ? $component['config'] : [],
                    [
                        'template' => 'CommunityEngineering_JapaneseAddress/checkout/billing-address'
                    ]
                );
            } else {
                $component['children'][$name] = $this->walkChildren($child);
            }
        }
        return $component;
    }
}
