<?php
/**
 * Copyright 2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
namespace Amazon\Core\Model\Config\Source;

use Magento\Framework\Option\ArrayInterface;

class PaymentRegion implements ArrayInterface
{
    const UNDEFINED_OPTION_LABEL = '-- Please Select --';

    /**
     * {@inheritdoc}
     */
    public function toOptionArray()
    {
        return [
            ['value' => '', 'label' => __(self::UNDEFINED_OPTION_LABEL)],
            ['value' => 'de', 'label' => __('Euro Region')],
            ['value' => 'uk', 'label' => __('United Kingdom')],
            ['value' => 'us', 'label' => __('United States')],
            ['value' => 'jp', 'label' => __('Japan')],
        ];
    }
}
